#include <iostream>
#include <vector>

using namespace std;

void makeatree(int l, int r, int n, vector<pair<int, int>> &tree, vector<char> &s){
    if (l==r){
        if (s[l]=='a'){
            tree[n].first++;
        }
        else{
            tree[n].second++;
        }
    }
    else{
        int mid=(l+r)/2;
        makeatree(l, mid, 2*n+1, tree, s);
        makeatree(mid+1, r, 2*n+2, tree, s);
        tree[n].first=tree[n*2+1].first+tree[n*2+2].first;
        tree[n].second=tree[n*2+1].second+tree[n*2+2].second;
    }
}

void update(int l, int r, int n, vector<pair<int, int>> &tree, vector<char> &s, int x, char a, char b){
    if (x>0){
        if (l==r){
            if (a=='a'){
                tree[n].first--;
                tree[n].second++;
            }
            else{
                tree[n].first++;
                tree[n].second--;
            }
            s[l]=b;
        }
        else{
            int mid=(l+r)/2;
            int c=0;
            if (a=='a'){
                c=tree[2*n+1].first;
            }
            else{
                c=tree[2*n+1].second;
            }

            if (x>c){
                update(mid+1, r, 2*n+2, tree, s, x-c, a, b);
            }
            update(l, mid, 2*n+1, tree, s, min(x, c), a, b);
            tree[n].first=tree[n*2+1].first+tree[n*2+2].first;
            tree[n].second=tree[n*2+1].second+tree[n*2+2].second;
        }
    }
}

int main(){
    int n,m;
    cin>>n>>m;
    vector<char> s(n);
    for (int i=0; i<n; i++){
        cin>>s[i];
    }
    pair<int, int> kek;
    kek.first=0;
    kek.second=0;
    vector<pair<int, int>> tree(4*n, kek);
    makeatree(0, n-1, 0, tree, s);
    int x;
    char a,b;
    for (int i=0; i<m; i++){
        cin>>x>>a>>b;
        update(0, n-1, 0, tree, s, x, a, b);
    }
    for (int j=0; j<n; j++){
        cout<<s[j];
    }
}